/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.items;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;
import noppes.npcs.CustomRegisters;
import noppes.npcs.api.ICustomElement;
import noppes.npcs.api.INbt;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.util.Util;

public class CustomFishingRod
extends ItemFishingRod
implements ICustomElement {
    protected NBTTagCompound nbtData;
    protected int enchantability = 1;
    protected ItemStack repairItemStack = ItemStack.field_190927_a;

    public CustomFishingRod(NBTTagCompound nbtItem) {
        this.nbtData = nbtItem;
        this.setRegistryName("customnpcs", "custom_" + nbtItem.func_74779_i("RegistryName"));
        this.func_77655_b("custom_" + nbtItem.func_74779_i("RegistryName"));
        if (nbtItem.func_150297_b("RepairItem", 10)) {
            this.repairItemStack = new ItemStack(nbtItem.func_74775_l("RepairItem"));
        }
        int n = this.field_77777_bU = nbtItem.func_150297_b("MaxStackSize", 3) ? nbtItem.func_74762_e("MaxStackSize") : 1;
        if (nbtItem.func_74762_e("MaxStackDamage") > 1) {
            this.func_77656_e(nbtItem.func_74762_e("MaxStackDamage"));
        }
        if (nbtItem.func_150297_b("Enchantability", 3)) {
            this.enchantability = nbtItem.func_74762_e("Enchantability");
        }
        this.func_77637_a(CustomRegisters.tabItems);
    }

    @Override
    public String getCustomName() {
        return this.nbtData.func_74779_i("RegistryName");
    }

    @Override
    public INbt getCustomNbt() {
        return Objects.requireNonNull(NpcAPI.Instance()).getINbt(this.nbtData);
    }

    public boolean func_82789_a(@Nonnull ItemStack toRepair, @Nonnull ItemStack repair) {
        if (this.repairItemStack.func_190926_b()) {
            return super.func_82789_a(toRepair, repair);
        }
        ItemStack mat = this.repairItemStack;
        if (OreDictionary.itemMatches((ItemStack)mat, (ItemStack)repair, (boolean)false)) {
            return true;
        }
        return super.func_82789_a(toRepair, repair);
    }

    public int func_77619_b() {
        return this.enchantability;
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        if (tab != CustomRegisters.tabItems && tab != CreativeTabs.field_78027_g) {
            return;
        }
        if (this.nbtData != null && this.nbtData.func_150297_b("ShowInCreative", 1) && !this.nbtData.func_74767_n("ShowInCreative")) {
            return;
        }
        items.add((Object)new ItemStack((Item)this));
        if (tab == CustomRegisters.tabItems) {
            Util.instance.sort(items);
        }
    }

    @Override
    public int getType() {
        if (this.nbtData != null && this.nbtData.func_150297_b("ItemType", 1)) {
            return this.nbtData.func_74771_c("ItemType");
        }
        return 8;
    }
}

